<?

/**
 *
 * Copyright(C), Nicecoder, 2000-2005, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */


if(!empty($_GET)) extract($_GET);
if(!empty($_POST)) extract($_POST);
if(!empty($_COOKIE)) extract($_COOKIE);

define('INSTALLATION', 1);

include "_init.php";


/*************************************
 step 1
*************************************/

if (empty($s)) {
  $next_step = 2;
  $process_title = "$script_name Installation";
  $message = $message_step1;
}


/*************************************
 step 2
*************************************/
elseif ($s==2) {
  $next_step = 3;
  $process_title = "Server Check";
  $message = CheckServerReq();
}


/*************************************
 step 3
*************************************/
elseif ($s==3) {
  $next_step = 4;
  $process_title = "Permissions Check";
  $message = CheckFilePermission();
}


/*************************************
 step 4
*************************************/
elseif ($s==4) {
  $next_step = 5;
  $process_title = "File Configuration";
  $message = ShowForm();
}


/*************************************
 step 5
*************************************/
elseif ($s==5) {
  $error_message = CheckForm();
  if (empty($error_message)) {
    $next_step = 6;
    WriteConfigurationFile();
    $process_title = "Create/Upgrade Database Tables";
    $message = ShowFormSQL();
  }
  else {
    $next_step = 5;
    $process_title = "File Configuration";
    $message = ShowForm();
  }
}


/*************************************
 step 6
*************************************/
elseif ($s==6) {
  if (!empty($sql_select)) {
    $next_step = 7;
    $process_title = "Create/Upgrade Database Tables";
    $message = ExecuteSQL($sql_select);
  }
  else {
    $next_bt = "";
    $process_title = "Installation Complete";
    $message = Finish();
  }
}


/*************************************
 step 7
*************************************/
elseif ($s==7) {
  $next_bt = "";
  $process_title = "Installation Complete";
  $message = Finish();
}


include "_install.html";


/*************************************
 function
*************************************/

function CheckServerReq() {
  global $req_php_module, $req_php_version, $module_ok, $module_failed;
  
  $phpversion = phpversion();
  $out = "<p>PHP $req_php_version ... ";
  if(version_compare($req_php_version, phpversion(), "<=")) {
    $out .= "$module_ok (current version: $phpversion)";
  }
  else {
    $out .= "$module_failed (current version: $phpversion)";
  }

  foreach($req_php_module as $key => $val) {
    $out .= "<p>PHP module $key is ";
    if(function_exists($val)) {
      $out .= $module_ok;
    }
    else {
      $out .= $module_failed;
    }
  }
  
  return $out;
}


function CheckFilePermission() {
  global $req_chmod_777, $writeable_ok, $writeable_failed;
  
  foreach($req_chmod_777 as $key => $val) {
    unset($arr);
    $arr = explode('|',$val);
    $val = $arr[0];

    $out .= "<p><b>../$val</b> is ";
    if(is_writeable("../$val")) {
      $out .= $writeable_ok;
    }
    else {
      $out .= $writeable_failed;
    }
  }
  
  // check template files
  $out .= "<p>Checking template files:<br>";
  $tpl_files = file('_template_files.txt');

  foreach($tpl_files as $key => $val) {
    $val = chop($val);
    $out .= "<br><font size=1>&nbsp ../themes/kosmos/$val is ";
    if(is_writeable("../themes/kosmos/$val")) {
      $out .= $writeable_ok;
    }
    else {
      $out .= $writeable_failed;
    }
    $out .= "</font>";
  }

  return $out;
}

function ShowForm() {
  global $message_step5, $pf, $error_message,
         $base_path, $site_url, $dbUsername, $dbPassword, $dbHostname, $dbName, $site_name;
  
  if(empty($pf)) {
    $path = dirname(__FILE__);
    $path = str_replace("\\", "/", $path);
    $base_path = str_replace('/install', '/', $path);
    
    $host = $_SERVER["HTTP_HOST"];
    if (empty($host)) { 
      $host = getenv("HTTP_HOST"); 
    }
    if (!isset($_SERVER["REQUEST_URI"]) || !$_SERVER["REQUEST_URI"]) {
      if (!($_SERVER["REQUEST_URI"] = @$_SERVER["PHP_SELF"])) {
        $_SERVER["REQUEST_URI"] = $_SERVER["SCRIPT_NAME"];
      }
      if (isset($_SERVER["QUERY_STRING"])) {
        $_SERVER["REQUEST_URI"] .= "?" . $_SERVER[ "QUERY_STRING" ];
      }
    }
    $ref = str_replace('/install/install.php', '', "http://" . $host. $_SERVER["REQUEST_URI"]);
    $site_url = $ref;
    
    $dbHostname = 'localhost';
  }
  
  $out = str_replace('<%$base_path%>', $base_path, $message_step5);
  $out = str_replace('<%$site_url%>', $site_url, $out);
  $out = str_replace('<%$dbUsername%>', $dbUsername, $out);
  $out = str_replace('<%$dbPassword%>', $dbPassword, $out);
  $out = str_replace('<%$dbHostname%>', $dbHostname, $out);
  $out = str_replace('<%$dbName%>', $dbName, $out);
  $out = str_replace('<%$site_name%>', stripslashes($site_name), $out);
  $out = str_replace('<%$error_message%>', $error_message, $out);

  return $out;
}


function CheckForm() {
  global $base_path, $site_url, $dbUsername, $dbPassword, $dbHostname, $dbName;

  // check database
  $found_db = true;
  @mysql_connect($dbHostname,$dbUsername,$dbPassword)
    OR $err = "Unable to connect to database";
  @mysql_select_db("$dbName")
    or $err = "Unable to select database";
  if(!empty($err)) $found_db = false;

  // check executable files inside base_path
  if (file_exists($_POST["base_path"].'indexu_exe.idf')) {
    $found_exe = true;
  }

  if ($found_db && !$found_exe) {
    $err= "Base path does not contain Indexu files";
  }
  
  return $err;
}


function WriteConfigurationFile() {
  global $base_path, $site_url, $dbUsername, $dbPassword, $dbHostname, $dbName, $site_name;

  $content = file_get_contents('_application.php');
  $content = str_replace('<%$base_path%>', $base_path, $content);
  $content = str_replace('<%$site_url%>', $site_url, $content);
  $content = str_replace('<%$dbUsername%>', $dbUsername, $content);
  $content = str_replace('<%$dbPassword%>', $dbPassword, $content);
  $content = str_replace('<%$dbHostname%>', $dbHostname, $content);
  $content = str_replace('<%$dbName%>', $dbName, $content);
  $content = str_replace('<%$site_name%>', $site_name, $content);
  $content = str_replace('<%$dbName%>', $dbName, $content);

  $filename = '../application.php';
  $fp = fopen($filename, 'w');
  fwrite($fp, $content);
  fclose($fp);
}


function ShowFormSQL() {
  global $sql_option;
  
  $i = 0;
  $out = "<p>Select your installation type:<br>";
  foreach($sql_option as $key => $val) {
    if ($i==0) {
      $checked = "checked";
    }
    else {
      $checked = "";
    }
    $out .= "<br><input type=radio name=sql_select value=\"$val\" $checked> $key";
    $i++;
  }

  return $out;
}


function ExecuteSQL($file) {
  global $dbConn, $message_step6, $dbUsername, $dbPassword, $dbHostname, $dbName;

  $qq = file_get_contents($file);
  include "../application.php";

  $arr = explode(';',$qq);
  
  foreach($arr as $key => $val) {
    $q = trim($val);
    $dbConn->Execute($q);
  }

  // do finalization here
  $file = str_replace('.sql', '.php', $file);
  if (file_exists($file)) {
    include $file;
  }

  return $message_step6;
}


function Finish() {
  global $message_step7;

  $out = $message_step7;

  return $out;
}
?>
